#include <p30fxxxx.h>
#include <spi.h>

/******************************************************************************
*     Function Name :   ReadSPI2                                              *
*     Description   :   This function will read single byte/ word  from SPI   *
                        bus. If SPI is configured for byte  communication     *
                        then upper byte of SPIBUF is masked.                  *         
*     Parameters    :   None                                                  *
*     Return Value  :   contents of SPIBUF register                           *
*******************************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

unsigned int ReadSPI2()
{         
    /* Check for Receive buffer full status bit of status register*/
    if (SPI2STATbits.SPIRBF)
    {
        SPI2STATbits.SPIROV = 0;
                
        if (SPI2CONbits.MODE16)
            return ( SPI2BUF );        /* return word read */
        else
            return (SPI2BUF & 0xff);   /* return byte read */
    }
	return -1;                         /* RBF bit is not set return error*/
}

#endif
